VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmDPC_File 
   Caption         =   "frmDPC_File"
   ClientHeight    =   3840
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   8625
   LinkTopic       =   "Form2"
   ScaleHeight     =   3840
   ScaleWidth      =   8625
   StartUpPosition =   3  'Windows Default
   Tag             =   "lbl_frmDPC_File_Title"
   Visible         =   0   'False
   Begin VB.CommandButton btn_Quit 
      Height          =   612
      Left            =   7920
      Style           =   1  'Graphical
      TabIndex        =   10
      Tag             =   "btn_Quit"
      Top             =   3000
      Width           =   612
   End
   Begin VB.CommandButton btn_Validate 
      Default         =   -1  'True
      Height          =   612
      Left            =   7200
      Style           =   1  'Graphical
      TabIndex        =   9
      Tag             =   "btn_Validate"
      Top             =   3000
      Width           =   612
   End
   Begin VB.Frame fra_Selection 
      Height          =   2760
      Left            =   120
      TabIndex        =   0
      Tag             =   "fra_Selection"
      Top             =   120
      Width           =   8415
      Begin VB.TextBox txt_FIL_Path 
         Height          =   375
         Left            =   1200
         TabIndex        =   13
         Tag             =   "FIL_Path"
         Top             =   2280
         Visible         =   0   'False
         Width           =   5415
      End
      Begin VB.CommandButton cmd_Save_As 
         Caption         =   "#Save As ..."
         Height          =   375
         Left            =   1200
         TabIndex        =   11
         Tag             =   "lbl_SaveAs"
         Top             =   1800
         Width           =   1815
      End
      Begin VB.TextBox txt_FIL_Ext 
         Height          =   375
         Left            =   1200
         TabIndex        =   7
         Tag             =   "FIL_Ext"
         Top             =   720
         Width           =   1215
      End
      Begin VB.CommandButton cmd_BrowseFile 
         Caption         =   "..."
         Height          =   375
         Left            =   6840
         TabIndex        =   5
         Top             =   1320
         Width           =   1215
      End
      Begin VB.TextBox txt_FileNamePath 
         Enabled         =   0   'False
         Height          =   375
         Left            =   1200
         TabIndex        =   4
         Top             =   1320
         Width           =   5415
      End
      Begin VB.TextBox txt_FIL_Id 
         Enabled         =   0   'False
         Height          =   285
         Left            =   7440
         TabIndex        =   3
         Tag             =   "FIL_Id"
         Top             =   720
         Visible         =   0   'False
         Width           =   615
      End
      Begin VB.TextBox txt_FileName 
         Height          =   375
         Left            =   6000
         TabIndex        =   2
         Tag             =   "FIL_FileName"
         Top             =   240
         Width           =   2055
      End
      Begin VB.TextBox txt_FIL_Name 
         Height          =   375
         Left            =   1200
         TabIndex        =   1
         Tag             =   "FIL_Name"
         Top             =   240
         Width           =   2775
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#File Name"
         Height          =   255
         Index           =   2
         Left            =   4560
         TabIndex        =   12
         Tag             =   "lbl_FIL_FileName"
         Top             =   360
         Width           =   1095
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Ext"
         Height          =   255
         Index           =   1
         Left            =   240
         TabIndex        =   8
         Tag             =   "lbl_FIL_Ext"
         Top             =   840
         Width           =   735
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Name"
         Height          =   255
         Index           =   0
         Left            =   240
         TabIndex        =   6
         Tag             =   "lbl_FIL_Name"
         Top             =   360
         Width           =   735
      End
   End
   Begin MSComDlg.CommonDialog dlg_Common 
      Left            =   120
      Top             =   3000
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
End
Attribute VB_Name = "frmDPC_File"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const C_ERRORRAISE As Long = 2500
Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const SCREEN_NAME As String = "frmDPC_File"
Private Const C_MSG_ID_BASE As Long = 9800

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

#If ENV = LIVE Then
Private mo_Db As Object
Private mo_FSO As Object
#Else
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_FSO As FileSystemObject
#End If

Private ms_DPCFileCachePath As String
Private ml_U_Code As Long
Private ms_Language_Code As String
Private mc_ScreenLabels As Long
Private mo_Tools As DPC_Tools
Private ms_FilePath                      As String       'used to save images from database
Private ml_iConcurrency As Long
Private mb_FileChanged As Boolean  'indicate if image picture was changed
Private mb_ShowSelectExisting As Boolean

Public Mode As eDPCScreenMode
Public FIL_Id As Long
Public Result As Boolean

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
End Property

Property Let U_Code(al_Code As Long)
  ml_U_Code = al_Code
End Property

Property Let ShowSelectExisting(ab_ShowSel As Boolean)
  mb_ShowSelectExisting = ab_ShowSel
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Sub Load_A_COM()
On Error GoTo ErrHandler

Dim ll_max As Long
    
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  
  ms_DPCFileCachePath = prg.AppCache_Dir & DPC_FILE_CACHE
  btn_Validate.Picture = LoadResPicture(RES_OK, 1)
  btn_Quit.Picture = LoadResPicture(RES_QUIT, 1)
  Set mo_FSO = New FileSystemObject
    
  ms_FilePath = prg.AppCache_Dir & DPC_FILE_CACHE
  
  mb_FileChanged = False
  Call ShowFile(FIL_Id, "")
  
  Call mo_Tools.EnableControl(txt_FileName, False)
  Call mo_Tools.EnableControl(txt_FIL_Ext, False)
  Call mo_Tools.EnableControl(txt_FileNamePath, False)
    
  If Mode = eDPCScreenMode.smNone Then
    Call mo_Tools.EnableControl(txt_FIL_Name, False)
    cmd_BrowseFile.Enabled = False
  End If
  
  If Mode <> eDPCScreenMode.smAdd Then
    cmd_Save_As.Enabled = True
  Else
    cmd_Save_As.Enabled = False
  End If
  
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, Me.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(Me.Controls, gl_CodePage, gl_CodePage, Me)
  Result = False
  Exit Sub
ErrHandler:
  Call ErrorHandler("Load_A_COM")
End Sub

Public Sub Unload_A_COM()
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(Me.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Db = Nothing
  Set mo_FSO = Nothing
  Set mo_Tools = Nothing
  Exit Sub
ErrHandler:
  Call ErrorHandler("Unload_A_COM")
End Sub



Private Function DeleteFile(ByVal al_FIL_Id As Long) As Boolean
Dim ls_FilName As String

  DeleteFile = False
  If al_FIL_Id = 0 Then Exit Function
  ls_FilName = ms_FilePath & "FIL" & al_FIL_Id
  If mo_FSO.FileExists(ls_FilName) Then
        Call mo_FSO.DeleteFile(ls_FilName)
  End If
  DeleteFile = True
End Function

Private Sub UploadFile(ByVal as_FileName As String, ByVal as_FIL_Id As String)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim ls_RequestIns As String
Dim ls_Filename As String

    ls_RequestIns = "INSERT INTO DPC_File (FIL_Id,FIL_File) VALUES ($FIL_Id$,?)"
    ls_RequestIns = mo_Tools.ReplacePlaceHolder(ls_RequestIns, "$FIL_Id$", as_FIL_Id)
        
    If Not mo_Db.FileToBlobSQL(ls_RequestIns, as_FileName, 9) Then
        Err.Raise ArmErr.SQLFailure, "FileToBlobSQL", mo_Db.LastErrorMessage & " Error writing blob: " & ls_RequestIns & " File: " & ls_Filename
    End If

    Exit Sub
ErrHandler:
    Call ErrorHandler("UploadFile as_FileName=" & as_FileName)
End Sub

Private Sub UpdateFile(ByVal as_FileName As String, ByVal as_FIL_Id As String)
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim ls_RequestUpd As String
Dim ls_Filename As String

    ls_RequestUpd = "UPDATE DPC_File SET FIL_File = ? WHERE FIL_Id = $FIL_Id$"
    ls_RequestUpd = mo_Tools.ReplacePlaceHolder(ls_RequestUpd, "$FIL_Id$", as_FIL_Id)
        
    If Not mo_Db.FileToBlobSQL(ls_RequestUpd, as_FileName, 9) Then
        Err.Raise ArmErr.SQLFailure, "FileToBlobSQL", mo_Db.LastErrorMessage & " Error writing blob: " & ls_RequestUpd & " File: " & ls_Filename
    End If

    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateFile as_FileName=" & as_FileName)
End Sub

Private Function ShowFile(ByVal al_FilId As Long, ByVal as_FileName As String) As Boolean
On Error GoTo ErrHandler

Dim ls_Request As String
Dim ll_Cursor As Long

    If al_FilId > 0 Then
        ls_Request = "exec DPC_FileInfo_sel " & al_FilId
        ls_Request = Replace(ls_Request, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
        ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
        
        If Not mo_Db.EOF(ll_Cursor) Then
            txt_FIL_Name.Text = mo_Db.GetFields(ll_Cursor, "FIL_Name")
            txt_FIL_Ext.Text = mo_Db.GetFields(ll_Cursor, "FIL_Ext")
            txt_FIL_Id.Text = al_FilId
            txt_FileName.Text = mo_Db.GetFields(ll_Cursor, "FIL_FileName")
            txt_FileNamePath.Text = ms_FilePath & "FIL" & al_FilId
            txt_FIL_Path.Text = mo_Db.GetFields(ll_Cursor, "FIL_Path")
            
            If txt_FIL_Ext.Text <> "" Then
                txt_FileNamePath.Text = txt_FileNamePath.Text & "." & txt_FIL_Ext.Text
            End If
            
            ml_iConcurrency = mo_Db.GetFields(ll_Cursor, "iConcurrency")
        Else
            Err.Raise ArmErr.CompFncFailed, "ShowFile", "#File does not exists in DPC_File table with FIL_Id=" & al_FilId
        End If
            
        Call mo_Db.Close(ll_Cursor)

    End If
    
    ShowFile = True
    
    Exit Function
ErrHandler:
        
    If ll_Cursor > 0 Then
        Call mo_Db.Close(ll_Cursor)
    End If

    ShowFile = False
    Call ErrorHandler("ShowFile")
End Function

Private Sub btn_Quit_Click()
On Error GoTo ErrHandler
    
  Result = False
  Hide
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Quit_Click")
End Sub

Private Sub btn_Validate_Click()
On Error GoTo ErrHandler
  
Dim ll_FIL_Id_orig As Long
Dim ls_Request As String

  Call mo_Tools.LockScreen(Me, True)
  
    If FIL_Id = 0 And Mode <> eDPCScreenMode.smAdd Then
        Result = True
        Hide
        Call mo_Tools.LockScreen(Me, False)
        Exit Sub
    End If
    
    If (Mode = eDPCScreenMode.smUpdate Or Mode = eDPCScreenMode.smAdd) And txt_FileNamePath.Text = "" Then
        Call mo_Tools.ShowMsg(mo_Db, ms_Language_Code, 9738, "#Please select file")
        Call mo_Tools.LockScreen(Me, False)
        Exit Sub
    End If
    
  
    If Mode = eDPCScreenMode.smUpdate And txt_FileNamePath.Text <> "" Then
    
        If mb_FileChanged = True Then
            ll_FIL_Id_orig = FIL_Id
            FIL_Id = mo_Tools.GetNextID(mo_Db, "DPC_File")
            txt_FIL_Id.Text = FIL_Id
            Call UploadFile(txt_FileNamePath, FIL_Id)
            
            ls_Request = "exec DPC_FileInfo_ins $FIL_Id$,$FIL_Name$,$FIL_FileName$,$FIL_Ext$,$FIL_Path$,$Z_creator$"
        
            ls_Request = mo_Tools.ReplaceRequestByFrameData(ls_Request, Me.Controls, fra_Selection)
            ls_Request = Replace(ls_Request, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$Z_creator$", ml_U_Code)
            
            Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request)
        Else
            ls_Request = "exec DPC_FileInfo_upd $FIL_Id$,$FIL_Name$,$FIL_FileName$,$FIL_Ext$,$FIL_Path$,$Z_last_upd_user$,$iConcurrency$"
            ls_Request = mo_Tools.ReplaceRequestByFrameData(ls_Request, Me.Controls, fra_Selection)
            ls_Request = Replace(ls_Request, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$Z_last_upd_user$", ml_U_Code)
            ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$iConcurrency$", ml_iConcurrency)
        
            Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request, 1)
        End If
                        
        'Call DeleteImage(ll_IMG_Id_orig)
    End If
  
    If Mode = eDPCScreenMode.smAdd And txt_FileNamePath <> "" Then
        
        FIL_Id = mo_Tools.GetNextID(mo_Db, "DPC_File")
        txt_FIL_Id.Text = FIL_Id
        Call UploadFile(txt_FileNamePath, FIL_Id)
    
        ls_Request = "exec DPC_FileInfo_ins $FIL_Id$,$FIL_Name$,$FIL_FileName$,$FIL_Ext$,$FIL_Path$,$Z_creator$"
    
        ls_Request = mo_Tools.ReplaceRequestByFrameData(ls_Request, Me.Controls, fra_Selection)
        ls_Request = Replace(ls_Request, "$Language_Code$", mo_Tools.SQLStr(Language_Code), , , vbTextCompare)
        ls_Request = Replace(ls_Request, "$Z_creator$", ml_U_Code)
        
        Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request)
    End If
  
  Result = True
  Hide
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("btn_Validate_Click")
End Sub

' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Me.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

Private Sub cmd_BrowseFile_Click()
On Error GoTo ErrHandler
    
Dim ls_Filename As String
    
    dlg_Common.Filter = "All files (*.*)|*.*"
    dlg_Common.CancelError = False
    Call dlg_Common.ShowOpen
    ls_Filename = dlg_Common.FileName
    If ls_Filename <> "" Then
        txt_FileNamePath.Text = ls_Filename
        txt_FileName.Text = right(ls_Filename, Len(ls_Filename) - InStrRev(ls_Filename, "\", -1, vbTextCompare))
        If InStrRev(txt_FileName.Text, ".", -1, vbTextCompare) > 0 Then
            txt_FIL_Name.Text = Left(txt_FileName.Text, InStrRev(txt_FileName.Text, ".", -1, vbTextCompare) - 1)
            txt_FIL_Ext.Text = right(txt_FileName.Text, Len(txt_FileName.Text) - InStrRev(txt_FileName.Text, ".", -1, vbTextCompare))
        Else
            txt_FIL_Name.Text = txt_FileName.Text
            txt_FIL_Ext.Text = ""
        End If
        txt_FIL_Path.Text = Left(ls_Filename, InStrRev(ls_Filename, "\", -1, vbTextCompare))
        mb_FileChanged = True
        Call ShowFile(-1, ls_Filename)
      
    End If
    Exit Sub
ErrHandler:
    Call ErrorMessage("cmd_BrowseFile_Click")
End Sub

Private Sub cmd_Save_As_Click()
On Error GoTo ErrHandler
    
Dim ls_Filename As String
    
    dlg_Common.Filter = "All files (*.*)|*.*"
    dlg_Common.CancelError = True
    dlg_Common.FileName = txt_FileName.Text
    dlg_Common.ShowSave
    
    If dlg_Common.FileName <> "" Then
        ls_Filename = dlg_Common.FileName
        If mo_FSO.FileExists(ls_Filename) Then
            If MsgBox(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 45, "#A file with this name already exists. Do you want to overwrite it?"), vbOKCancel) = vbCancel Then
                Exit Sub
            End If
        End If
        If Not mo_Db.BlobToFileSQL("SELECT FIL_File FROM DPC_File WHERE FIL_Id=" & txt_FIL_Id.Text, ls_Filename, True, False) Then
          Call MsgBox(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 43, "#Cannot download the file from db - FIL_Id:" & txt_FIL_Id.Text))
          Exit Sub
        End If
    
    End If
    Exit Sub
ErrHandler:
    If Err.Number = cdlCancel Then  ' this line is not executed on cancel
        Exit Sub
    End If
    Call ErrorMessage("cmd_Save_As_Click")
End Sub

